/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitOscillator;
import processing.core.PApplet;
import processing.sound.Engine;
import processing.sound.JSynCircuit;
import processing.sound.Modulator;
import processing.sound.Sound;
import processing.sound.SoundObject;

public abstract class Oscillator<JSynOscillator extends UnitOscillator>
extends SoundObject
implements Modulator {
    protected JSynOscillator oscillator;

    protected Oscillator(PApplet pApplet, JSynOscillator JSynOscillator) {
        super(pApplet);
        this.oscillator = JSynOscillator;
        ((UnitOscillator)this.oscillator).frequency.setValueAdded(true);
        ((UnitOscillator)this.oscillator).amplitude.setValueAdded(true);
        this.circuit = new JSynCircuit(this.oscillator.getOutput());
        this.amplitude = ((UnitOscillator)this.oscillator).amplitude;
    }

    @Override
    public UnitOutputPort getModulator() {
        this.circuit.setSynthesisEngine(Sound.getSynthesisEngine());
        return this.circuit.getOutput();
    }

    public void freq(float f) {
        ((UnitOscillator)this.oscillator).frequency.set((double)f);
    }

    public void freq(Modulator modulator) {
        Engine.setModulation(((UnitOscillator)this.oscillator).frequency, modulator);
    }

    public void amp(Modulator modulator) {
        Engine.setModulation(((UnitOscillator)this.oscillator).amplitude, modulator);
    }

    @Override
    public void play() {
        super.play();
    }

    public void play(float f, float f2) {
        this.freq(f);
        this.amp(f2);
        this.play();
    }

    public void play(float f, float f2, float f3) {
        this.add(f3);
        this.play(f, f2);
    }

    public void play(float f, float f2, float f3, float f4) {
        this.set(f, f2, f3, f4);
        this.play();
    }

    public void set(float f, float f2, float f3) {
        this.freq(f);
        this.amp(f2);
        this.pan(f3);
    }

    public void set(float f, float f2, float f3, float f4) {
        this.freq(f);
        this.amp(f2);
        this.add(f3);
        this.pan(f4);
    }

    @Override
    public void stop() {
        super.stop();
    }
}

