/*
 * Decompiled with CFR 0.152.
 */
import controlP5.Bang;
import controlP5.ControlP5;
import controlP5.Textfield;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import processing.data.StringList;
import processing.net.Client;
import processing.sound.SinOsc;
import processing.sound.SoundFile;

public class aprsClient
extends PApplet {
    ControlP5 cp5;
    String version;
    Client sock;
    SinOsc snd;
    SoundFile snd_file;
    SoundFile meow;
    int historyMax = 16383;
    boolean CONNECTED = false;
    String cr = "\r";
    String lf = "\n";
    String crlf = "\r\n";
    int currentBcnPos = 0;
    PImage loc_img;
    PImage spkr_img;
    String mybeacon = "VA3ODC D-Star/APRS - aprs-j ver0.01";
    Button but = new Button(150, 40, "BEACON", this.color(255, 255, 0), this.color(25, 25, 150), 18);
    Button select = new Button(150, 40, "Next->", this.color(255, 255, 0), this.color(25, 25, 150), 18);
    Button edFavorites = new Button(100, 40, "Faves", this.color(255, 255, 0), this.color(25, 25, 150), 18);
    Button edSetup = new Button(100, 40, "Setup", this.color(255, 255, 0), this.color(25, 25, 150), 18);
    Button edBeacons = new Button(100, 40, "Beacons", this.color(255, 255, 0), this.color(25, 25, 150), 18);
    Button butSaveHistory = new Button(100, 40, "Save H", this.color(255, 255, 0), this.color(25, 25, 150), 18);
    Button butClearHistory = new Button(100, 40, "Clear H", this.color(255, 255, 0), this.color(25, 25, 150), 18);
    MyStuff my = new MyStuff();
    String lastBeacon = "";
    String nextBeacon = "";
    StringList history = new StringList();
    StringList favourites = new StringList();
    StringList lastFav = new StringList();
    StringList beacons = new StringList();
    AprsObject current = new AprsObject("MARTEN");
    AprsObject[] last = new AprsObject[6];
    AprsObject[] temp = new AprsObject[7];
    String url1;
    String url2;
    PFont font;

    public void setup() {
        this.background(0.0f, 0.0f, 30.0f);
        PFont font = this.createFont("Courier New", 14.0f);
        this.textFont(font, 16.0f);
        this.cp5 = new ControlP5((PApplet)this);
        ((Textfield)((Textfield)this.cp5.addTextfield("callsign").setPosition(80.0f, 290.0f)).setSize(90, 30).setFont(font)).setAutoClear(false);
        ((Textfield)((Textfield)this.cp5.addTextfield("message").setPosition(180.0f, 290.0f)).setSize(250, 30).setFont(font)).setAutoClear(false);
        ((Bang)this.cp5.addBang("Send").setPosition(450.0f, 290.0f)).setSize(60, 30);
        this.history = new StringList();
        this.favourites = new StringList();
        this.background(0);
        this.fill(255);
        this.textSize(48.0f);
        this.text("loading user...", 300.0f, this.width / 2);
        this.loadUserParams();
        this.background(0);
        this.text("loading favourites...", 300.0f, this.width / 2);
        this.my.beacon = String.valueOf(this.my.callsign) + "-" + this.my.id + ">APMI06,TCPIP*,qAS," + this.my.callsign + ":=" + this.my.lat + this.my.sL + this.my.lon + this.my.sR;
        this.loadFavourites();
        this.background(0);
        this.text("loading beacons...", 300.0f, this.width / 2);
        this.loadBeacons();
        this.snd = new SinOsc((PApplet)this);
        this.snd_file = new SoundFile((PApplet)this, "dun-dun.mp3");
        this.snd_file.amp(0.5f);
        this.meow = new SoundFile((PApplet)this, "meow.mp3");
        this.meow.amp(0.3f);
        this.textSize(16.0f);
        int k = 0;
        while (k < this.last.length) {
            this.last[k] = new AprsObject("hello " + k);
            this.last[k].update("N1KK0-10>path:>status");
            this.last[k].x = 700;
            this.last[k].y = (k - 1) * 200 + 20;
            ++k;
        }
        int m = 0;
        while (m < 5) {
            this.temp[m] = new AprsObject("hello " + m);
            this.temp[m].update("MARTEN-10>path:>cool status");
            this.temp[m].x = 700;
            this.temp[m].y = (m - 1) * 200 + 20;
            ++m;
        }
        this.current.update("NIKKO>pathway:>status");
        this.loc_img = this.loadImage("location-80.png");
        this.spkr_img = this.loadImage("speaker.png");
        this.nextBeacon = this.beacons.get(PApplet.parseInt((float)this.random(this.beacons.size())));
        this.fill(255);
        this.textSize(48.0f);
        this.background(0);
        this.text("connecting...", 200.0f, 600.0f);
        this.sockConnect();
    }

    public void Send() {
        aprsClient.print((String)"the following text was submitted :");
        this.url1 = ((Textfield)this.cp5.get(Textfield.class, "callsign")).getText();
        this.url2 = ((Textfield)this.cp5.get(Textfield.class, "message")).getText();
        this.sendMessage(this.url1, this.url2);
    }

    public void showRecord(AprsObject rec) {
        rec.show();
    }

    public void draw() {
        this.snd.stop();
        this.current.show();
        if (this.CONNECTED) {
            this.showTime();
            this.current.show();
            if (this.sock.available() > 0) {
                String data = this.sock.readString();
                if (data.indexOf("#") == 0) {
                    return;
                }
                String[] t = aprsClient.split((String)data, (String)this.crlf);
                int i = 0;
                while (i < t.length) {
                    if (t[i].length() > 0) {
                        AprsObject packet = new AprsObject(t[i]);
                        packet.update(t[i]);
                        this.current = packet;
                        this.windowTitle(packet.callsign);
                        this.showTime();
                        this.history.append(String.valueOf(this.timestamp()) + " " + t[i]);
                        packet.x = 30;
                        packet.y = 20;
                        packet.show();
                        if (this.inList(this.parseCall(t[i]))) {
                            this.showTime();
                            packet.update(t[i]);
                            packet.x = 30;
                            packet.y = 20;
                            packet.show();
                            int j = this.last.length - 2;
                            while (j >= 0) {
                                this.last[j + 1] = this.last[j];
                                --j;
                            }
                            this.last[0] = packet;
                        }
                        packet.x = 30;
                        packet.y = 20;
                        packet.show();
                        this.showTime();
                    }
                    ++i;
                }
            }
        }
        this.background(30.0f, 0.0f, 0.0f);
        this.textSize(40.0f);
        this.text("va3odc.com", 100.0f, 80.0f);
        this.printHistory();
        this.current.show();
        int k = 0;
        while (k < this.last.length) {
            this.last[k].x = 700;
            this.last[k].y = k * this.last[k].h;
            this.last[k].show();
            ++k;
        }
        this.showButtons();
        this.select.show(30.0f, 160.0f);
        this.fill(170);
        this.text(this.nextBeacon, 200.0f, 190.0f);
        this.but.show(30.0f, 205.0f);
        this.fill(170);
        this.text("last bcn: " + this.lastBeacon, 30.0f, 275.0f);
        this.text("msg: ", 30.0f, 310.0f);
        this.showTime();
    }

    public void showButtons() {
        this.edFavorites.show(30.0f, 660.0f);
        this.edBeacons.show(150.0f, 660.0f);
        this.edSetup.show(270.0f, 660.0f);
        this.butSaveHistory.show(390.0f, 660.0f);
        this.butClearHistory.show(510.0f, 660.0f);
        this.textSize(14.0f);
        this.fill(150.0f, 150.0f, 10.0f);
        this.text("changes require restart!", 110.0f, 718.0f);
    }

    public void mouseClicked() {
        if (this.but.hover()) {
            this.beaconNow("");
        }
        if (this.select.hover()) {
            this.randomBeaconSelect();
        }
        if (this.edFavorites.hover()) {
            this.openNotepad("callsigns.txt");
        }
        if (this.edBeacons.hover()) {
            this.openNotepad("beacons.txt");
        }
        if (this.edSetup.hover()) {
            this.openNotepad("setup.txt");
        }
        if (this.butClearHistory.hover()) {
            this.history.clear();
        }
        if (this.butSaveHistory.hover()) {
            String[] stringArray = this.history.toArray(new String[this.history.size()]);
            this.saveStrings("history.txt", stringArray);
            this.history.append("-------- ===== >> DATA SAVED in history.txt << ======= ---------");
        }
    }

    public void openNotepad(String filename) {
        String callFile = String.valueOf(this.sketchPath()) + "/" + filename;
        String a = "notepad.exe " + callFile;
        aprsClient.launch((String[])new String[]{a});
    }

    public void randomBeaconSelect() {
        ++this.currentBcnPos;
        if (this.currentBcnPos > this.beacons.size() - 1) {
            this.currentBcnPos = 0;
        }
        this.nextBeacon = this.beacons.get(this.currentBcnPos);
    }

    public String timestamp() {
        return String.valueOf(aprsClient.nf((int)aprsClient.hour(), (int)2)) + ":" + aprsClient.nf((int)aprsClient.minute(), (int)2) + ":" + aprsClient.nf((int)aprsClient.second(), (int)2) + " ";
    }

    public void showTime() {
        this.fill(60);
        this.rect(520.0f, 85.0f, 120.0f, 20.0f);
        this.fill(255);
        this.textSize(20.0f);
        this.text(this.timestamp(), 530.0f, 100.0f);
    }

    public void loadUserParams() {
        String[] lines = this.loadStrings("setup.txt");
        this.my.callsign = lines[0];
        this.my.id = lines[1];
        this.my.pass = lines[2];
        this.my.filter = lines[3];
        this.my.bcnTimeout = PApplet.parseInt((String)lines[4]);
        this.my.lat = lines[5];
        this.my.lon = lines[6];
        this.my.latD = PApplet.parseFloat((String)lines[7]);
        this.my.lonD = PApplet.parseFloat((String)lines[8]);
        this.my.symbol = lines[9];
        this.my.sL = this.my.symbol.substring(0, 1);
        this.my.sR = this.my.symbol.substring(1, 2);
        this.my.login = "user " + this.my.callsign + "-" + this.my.id + " pass " + this.my.pass + " ver APRSdashboard 0.04 filter " + this.my.filter;
    }

    public void loadFavourites() {
        String[] lines = this.loadStrings("callsigns.txt");
        this.favourites.clear();
        int i = 0;
        while (i < lines.length) {
            this.favourites.append(lines[i]);
            ++i;
        }
    }

    public void loadBeacons() {
        String[] lines = this.loadStrings("beacons.txt");
        int i = 0;
        while (i < lines.length) {
            this.beacons.append(lines[i]);
            ++i;
        }
    }

    public boolean inList(String call) {
        if (call != null) {
            int i = 0;
            while (i < this.favourites.size()) {
                String g = this.favourites.get(i);
                if (call.contains(g)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void sockConnect() {
        this.sock = new Client((PApplet)this, "euro.aprs2.net", 14580);
        this.sock.write(String.valueOf(this.my.login) + this.crlf);
        this.CONNECTED = true;
    }

    public void printHistory() {
        int numlines;
        StringList temp = new StringList();
        int hsize = this.history.size();
        if (hsize < (numlines = 20)) {
            numlines = hsize;
        }
        int i = hsize - 1;
        while (i >= hsize - numlines) {
            temp.append(this.history.get(i));
            --i;
        }
        this.fill(255.0f, 255.0f, 0.0f);
        this.textSize(20.0f);
        this.text("history " + this.history.size(), 20.0f, 380.0f);
        this.textSize(12.0f);
        this.pushMatrix();
        this.translate(10.0f, 400.0f);
        float fadespeed = 15.0f;
        int k = 0;
        while (k < temp.size()) {
            String dt = temp.get(k);
            this.fill(250.0f - (float)k * fadespeed);
            if (this.inList(this.parseCall(dt))) {
                this.fill(0.0f, 255.0f, 0.0f);
            }
            this.text(dt, 0.0f, 18 * k);
            ++k;
        }
        this.fill(0);
        this.popMatrix();
        if (hsize >= this.historyMax) {
            this.history.remove(0);
        }
    }

    public String parseCall(String d) {
        String[] arr = aprsClient.split((String)d, (char)'>');
        String H = arr[0];
        return H;
    }

    public void sendMessage(String call, String msg) {
        aprsClient.println((Object[])new Object[]{"Beacon", call, msg});
        if (this.CONNECTED) {
            if (call.length() < 4) {
                return;
            }
            if (msg.length() < 1) {
                msg = "<->";
            }
            String cs = call.toUpperCase();
            String bacon = String.valueOf(this.my.callsign) + "-" + this.my.id + ">APMI06,TCPIP*,qAS," + this.my.callsign + "::";
            cs = String.valueOf(cs) + "          ";
            cs = cs.substring(0, 9);
            String ack = "{" + aprsClient.str((int)PApplet.parseInt((float)this.random(10000.0f, 99999.0f)));
            bacon = String.valueOf(bacon) + cs + ":" + msg + ack;
            this.sock.write(String.valueOf(bacon) + this.crlf);
        }
    }

    public void beaconNow(String txt) {
        if (this.CONNECTED) {
            if (this.nextBeacon.length() < 1) {
                String string = this.beacons.get(PApplet.parseInt((float)this.random(this.beacons.size())));
            }
            String bcn = this.nextBeacon;
            this.sock.write(String.valueOf(this.my.beacon) + bcn + this.crlf);
            this.lastBeacon = String.valueOf(this.timestamp()) + " " + bcn;
        }
    }

    public float lon2ddd(String deg) {
        if (deg.length() < 9) {
            return 0.0f;
        }
        float pm = -1.0f;
        float min2dec = 1.6666666f;
        if (deg.substring(8) == "E") {
            pm = -pm;
        }
        float a = PApplet.parseFloat((String)deg.substring(0, 3));
        float b = aprsClient.round((float)(PApplet.parseFloat((String)deg.substring(3, 5)) * min2dec)) * 100;
        float c = PApplet.parseFloat((String)deg.substring(6, 8));
        float togo = (a + (b + c) / 10000.0f) * pm;
        return togo;
    }

    public float lat2ddd(String deg) {
        if (deg.length() < 8) {
            return 0.0f;
        }
        float pm = 1.0f;
        float min2dec = 1.6666666f;
        if (deg.substring(7) == "S") {
            pm = -pm;
        }
        float a = PApplet.parseFloat((String)deg.substring(0, 2));
        float b = aprsClient.round((float)(PApplet.parseFloat((String)deg.substring(2, 4)) * min2dec)) * 100;
        float c = PApplet.parseFloat((String)deg.substring(5, 7));
        float togo = (a + (b + c) / 10000.0f) * pm;
        return togo;
    }

    public void settings() {
        this.size(1150, 720);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"aprsClient"};
        if (passedArgs != null) {
            PApplet.main((String[])aprsClient.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class AprsObject {
        String callsign;
        String id;
        String path;
        String mode;
        String tail;
        String symL;
        String symR;
        String lat;
        String lon;
        String status;
        String msgtext;
        float latD;
        float lonD;
        float bearing;
        float distance;
        String telemetry;
        String tstamp;
        String tag;
        int x;
        int y;
        int w = 450;
        int h = 120;
        String display;
        int titleBack;
        int titleFore;
        int bodyBack;
        int bodyFore;
        int brdrColour;
        int shadowColour;
        int clr;

        AprsObject(String t) {
            this.clr = aprsClient.this.color(100, 26, 179);
            this.brdrColour = aprsClient.this.color(144);
            this.brdrColour = aprsClient.this.color(0);
            this.bodyBack = aprsClient.this.color(0);
            this.bodyFore = aprsClient.this.color(255);
            this.titleBack = aprsClient.this.color(60, 70, 80);
            this.titleFore = aprsClient.this.color(255, 255, 255);
            this.shadowColour = aprsClient.this.color(60, 70, 80, 100);
            this.display = "ve3ugg.com catsrus.ca";
        }

        public void update(String aprsStringFormat) {
            this.callsign = "";
            this.id = "";
            this.path = "";
            this.mode = "";
            this.tail = "";
            this.symL = "";
            this.symR = "";
            this.lat = "";
            this.lon = "";
            this.status = "";
            this.display = "";
            this.telemetry = "";
            this.tstamp = "00:00:00";
            this.latD = 0.0f;
            this.lonD = 0.0f;
            this.bearing = 0.0f;
            this.distance = 0.0f;
            String tail = aprsStringFormat;
            this.display = aprsStringFormat;
            this.tstamp = aprsClient.this.timestamp();
            if (!aprsStringFormat.contains(">")) {
                return;
            }
            String[] arr = aprsClient.split((String)tail, (char)'>');
            this.callsign = arr[0];
            tail = tail.substring(arr[0].length() + 1);
            arr = aprsClient.split((String)tail, (char)':');
            this.path = arr[0];
            tail = tail.substring(arr[0].length() + 1);
            this.mode = tail.substring(0, 1);
            if ((tail = tail.substring(1, tail.length())).length() < 1) {
                return;
            }
            switch (this.mode) {
                case ">": {
                    this.status = tail;
                    break;
                }
                case "!": {
                    this.lat = tail.substring(0, 8);
                    this.latD = aprsClient.this.lat2ddd(this.lat);
                    this.symL = tail.substring(8, 9);
                    this.symR = tail.substring(17, 18);
                    this.lon = tail.substring(9, 18);
                    this.lonD = aprsClient.this.lon2ddd(this.lon);
                    this.distance = this.haversine(this.lat, this.lon, aprsClient.this.my.lat, aprsClient.this.my.lon);
                    tail = tail.substring(18);
                    this.status = "! pos w/o timestamp";
                    this.display = tail;
                    break;
                }
                case "=": {
                    this.lat = tail.substring(0, 8);
                    this.latD = aprsClient.this.lat2ddd(this.lat);
                    this.symL = tail.substring(8, 9);
                    this.symR = tail.substring(17, 18);
                    this.lon = tail.substring(9, 18);
                    this.lonD = aprsClient.this.lon2ddd(this.lon);
                    this.distance = this.haversine(this.lat, this.lon, aprsClient.this.my.lat, aprsClient.this.my.lon);
                    tail = tail.substring(18);
                    this.status = "= pos w/o timestamp";
                    this.display = tail;
                    break;
                }
                case "@": {
                    if (tail.length() < 1) {
                        return;
                    }
                    tail = tail.substring(7);
                    this.lat = tail.substring(0, 8);
                    this.latD = aprsClient.this.lat2ddd(this.lat);
                    this.symL = "/";
                    this.lon = tail.substring(9, 18);
                    this.lonD = aprsClient.this.lon2ddd(this.lon);
                    this.distance = this.haversine(this.lat, this.lon, aprsClient.this.my.lat, aprsClient.this.my.lon);
                    tail = tail.substring(18);
                    this.status = "@ pos with timestamp";
                    this.display = tail;
                    break;
                }
                case "/": {
                    tail = tail.substring(7);
                    this.lat = tail.substring(0, 8);
                    this.latD = aprsClient.this.lat2ddd(this.lat);
                    this.symL = "/";
                    this.lon = tail.substring(9, 18);
                    this.lonD = aprsClient.this.lon2ddd(this.lon);
                    this.distance = this.haversine(this.lat, this.lon, aprsClient.this.my.lat, aprsClient.this.my.lon);
                    tail = tail.substring(20);
                    this.status = "/ pos with timestamp";
                    this.display = tail;
                    break;
                }
                case ":": {
                    this.status = "message ";
                    if (tail.contains(aprsClient.this.my.callsign)) {
                        tail = "<>" + tail;
                    }
                    this.display = tail;
                    break;
                }
                case "`": {
                    this.status = "mic-e ";
                    this.display = tail;
                    break;
                }
                case ";": {
                    this.status = "object ";
                    this.display = tail.substring(17, 35);
                    this.display = this.display.replace(" ", "0");
                    this.lat = this.display.substring(0, 8);
                    this.latD = aprsClient.this.lat2ddd(this.lat);
                    this.symL = "/";
                    this.lon = this.display.substring(9, 18);
                    this.lonD = aprsClient.this.lon2ddd(this.lon);
                    this.distance = this.haversine(this.lat, this.lon, aprsClient.this.my.lat, aprsClient.this.my.lon);
                    this.display = tail.substring(35);
                    break;
                }
                case "<": {
                    this.status = "station capabilities ";
                    this.display = tail;
                    break;
                }
                case "#": {
                    this.status = "peet bros weather";
                    this.display = tail;
                    break;
                }
                case "$": {
                    this.status = "raw gps";
                    this.display = tail;
                    break;
                }
                case "*": {
                    this.status = "peet bros weather";
                    this.display = tail;
                    break;
                }
                case "_": {
                    this.status = "weather";
                    this.display = tail;
                    break;
                }
                case "%": {
                    this.status = "microfinder";
                    break;
                }
                case "T": {
                    this.telemetry = tail;
                    this.status = "telemetry ";
                    this.display = tail;
                    break;
                }
                default: {
                    this.status = "- none";
                    this.display = tail;
                }
            }
        }

        public void show() {
            aprsClient.this.pushMatrix();
            aprsClient.this.translate(this.x, this.y);
            aprsClient.this.fill(this.shadowColour);
            aprsClient.this.fill(this.titleBack);
            aprsClient.this.rect(2.0f, 2.0f, this.w, this.h);
            aprsClient.this.fill(this.bodyBack);
            aprsClient.this.stroke(this.brdrColour);
            aprsClient.this.rect(0.0f, 0.0f, this.w, this.h);
            aprsClient.this.fill(24);
            aprsClient.this.rect(0.0f, 0.0f, 450.0f, 20.0f);
            aprsClient.this.textSize(28.0f);
            aprsClient.this.fill(this.titleFore);
            aprsClient.this.text(this.callsign, 10.0f, 20.0f);
            aprsClient.this.textSize(20.0f);
            aprsClient.this.fill(220.0f, 220.0f, 10.0f);
            aprsClient.this.text(this.tstamp, 300.0f, 20.0f);
            aprsClient.this.textSize(14.0f);
            aprsClient.this.fill(255);
            aprsClient.this.text(this.path, 10.0f, 45.0f);
            aprsClient.this.textSize(14.0f);
            if (this.mode == ":") {
                aprsClient.this.fill(0.0f, 100.0f, 255.0f);
            } else {
                aprsClient.this.fill(255);
            }
            aprsClient.this.text(this.status, 10.0f, 60.0f);
            String old = this.display;
            if (this.display.length() > 50) {
                old = this.display.substring(50);
                this.display = this.display.substring(0, 49);
                aprsClient.this.text(this.display, 10.0f, 85.0f);
                if (old.length() > 50) {
                    old = old.substring(0, 49);
                }
                aprsClient.this.text(old, 10.0f, 105.0f);
            } else {
                aprsClient.this.text(this.display, 10.0f, 85.0f);
            }
            if (this.distance > 0.0f) {
                aprsClient.this.textSize(14.0f);
                aprsClient.this.fill(255);
                aprsClient.this.text(String.valueOf(aprsClient.nf((float)this.distance, (int)0, (int)1)) + "km", 200.0f, 17.0f);
                aprsClient.this.image(aprsClient.this.loc_img, 170.0f, 0.0f, 22.0f, 22.0f);
            }
            aprsClient.this.popMatrix();
        }

        public float haversine(String la1, String lo1, String la2, String lo2) {
            float R = 6378.1343f;
            float dla1 = aprsClient.this.lat2ddd(la1) / 57.295776f;
            float dlo1 = aprsClient.this.lon2ddd(lo1) / 57.295776f;
            float dla2 = aprsClient.this.lat2ddd(la2) / 57.295776f;
            float dlo2 = aprsClient.this.lon2ddd(lo2) / 57.295776f;
            float d = aprsClient.acos((float)(aprsClient.sin((float)dla1) * aprsClient.sin((float)dla2) + aprsClient.cos((float)dla1) * aprsClient.cos((float)dla2) * aprsClient.cos((float)(dlo2 - dlo1)))) * R;
            this.bearing = aprsClient.atan2((float)(aprsClient.sin((float)(dlo2 - dlo1)) * aprsClient.cos((float)dla2)), (float)(aprsClient.cos((float)dla1) * aprsClient.sin((float)dla2) - aprsClient.sin((float)dla1) * aprsClient.cos((float)dla2) * aprsClient.cos((float)(dlo2 - dlo1)))) * 28.647888f;
            return d;
        }
    }

    class Button {
        int x = 0;
        int y = 0;
        int w = 100;
        int h = 40;
        String caption = "ADD watch";
        int fcolor;
        int bcolor;
        int txtsize = 18;
        boolean hovering = false;
        boolean dragging = false;

        Button(int w, int h, String caption, int fcolor, int bcolor, int txtsize) {
            this.w = w;
            this.h = h;
            this.caption = caption;
            this.fcolor = fcolor;
            this.bcolor = bcolor;
            this.txtsize = txtsize;
        }

        public void show(float xx, float yy) {
            this.x = PApplet.parseInt((float)xx);
            this.y = PApplet.parseInt((float)yy);
            if (this.hover()) {
                aprsClient.this.fill(255);
                aprsClient.this.rect(this.x + 2, this.y + 2, this.w, this.h);
            }
            aprsClient.this.fill(this.bcolor);
            aprsClient.this.rect(this.x, this.y, this.w, this.h);
            aprsClient.this.fill(this.fcolor);
            aprsClient.this.textSize(this.txtsize);
            aprsClient.this.textAlign(3, 3);
            aprsClient.this.text(this.caption, this.x + this.w / 2, this.y + this.h / 2);
            aprsClient.this.textAlign(37);
        }

        public boolean hover() {
            boolean test = aprsClient.this.mouseX > this.x && aprsClient.this.mouseX < this.x + this.w && aprsClient.this.mouseY > this.y && aprsClient.this.mouseY < this.y + this.h;
            return test;
        }
    }

    class MyStuff {
        String callsign;
        String id;
        String pass;
        String login;
        String filter;
        String lat;
        String lon;
        float latD;
        float lonD;
        String beacon;
        int bcnTimeout;
        String symbol;
        String sL;
        String sR;

        MyStuff() {
        }
    }
}

