/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.engine;

public class LoadAnalyzer {
    private long stopTime = System.nanoTime();
    private long previousStopTime;
    private long startTime;
    private double averageTotalTime;
    private double averageOnTime;

    protected LoadAnalyzer() {
    }

    public void stop() {
        this.previousStopTime = this.stopTime;
        this.stopTime = System.nanoTime();
        long onTime = this.stopTime - this.startTime;
        long totalTime = this.stopTime - this.previousStopTime;
        if (totalTime > 0L) {
            double rate = 0.01;
            this.averageOnTime = this.averageOnTime * (1.0 - rate) + (double)onTime * rate;
            this.averageTotalTime = this.averageTotalTime * (1.0 - rate) + (double)totalTime * rate;
        }
    }

    public void start() {
        this.startTime = System.nanoTime();
    }

    public double getAverageLoad() {
        if (this.averageTotalTime > 0.0) {
            return this.averageOnTime / this.averageTotalTime;
        }
        return 0.0;
    }
}

