/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.ports;

import com.jsyn.ports.PortBlockPart;
import com.jsyn.ports.UnitBlockPort;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.UnitGenerator;
import java.io.PrintStream;

public class InputMixingBlockPart
extends PortBlockPart {
    private double[] mixer = new double[8];
    private double current;
    private UnitInputPort unitInputPort;

    InputMixingBlockPart(UnitInputPort unitInputPort, double defaultValue) {
        super(unitInputPort, defaultValue);
        this.unitInputPort = unitInputPort;
    }

    @Override
    public double getValue() {
        return this.current;
    }

    @Override
    protected void setValue(double value) {
        this.current = value;
        super.setValue(value);
    }

    @Override
    public double[] getValues() {
        double[] result;
        int numConnections = this.getConnectionCount();
        if (numConnections == 0) {
            result = super.getValues();
        } else {
            int i;
            PortBlockPart otherPart;
            double[] inputs;
            int jCon = 0;
            if (this.unitInputPort.isValueAdded()) {
                inputs = super.getValues();
                jCon = 0;
            } else {
                otherPart = this.getConnection(jCon);
                inputs = otherPart.getValues();
                jCon = 1;
            }
            for (i = 0; i < this.mixer.length; ++i) {
                this.mixer[i] = inputs[i];
            }
            while (jCon < numConnections) {
                otherPart = this.getConnection(jCon);
                inputs = otherPart.getValues();
                for (i = 0; i < this.mixer.length; ++i) {
                    int n = i;
                    this.mixer[n] = this.mixer[n] + inputs[i];
                }
                ++jCon;
            }
            result = this.mixer;
        }
        this.current = result[0];
        return result;
    }

    private void printIndentation(PrintStream out, int level) {
        for (int i = 0; i < level; ++i) {
            out.print("    ");
        }
    }

    private String portToString(UnitBlockPort port) {
        UnitGenerator ugen = port.getUnitGenerator();
        return ugen.getClass().getSimpleName() + "." + port.getName();
    }

    public void printConnections(PrintStream out, int level) {
        for (int i = 0; i < this.getConnectionCount(); ++i) {
            PortBlockPart part = this.getConnection(i);
            this.printIndentation(out, level);
            out.println(this.portToString(this.getPort()) + " <--- " + this.portToString(part.getPort()));
            part.getPort().getUnitGenerator().printConnections(out, level + 1);
        }
    }
}

