/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.swing;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.swing.DoubleBoundedRangeModel;
import com.jsyn.swing.DoubleBoundedRangeSlider;
import com.jsyn.swing.ExponentialRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PortControllerFactory {
    private static final int RESOLUTION = 100000;

    public static DoubleBoundedRangeSlider createPortSlider(final UnitInputPort port) {
        DoubleBoundedRangeModel rangeModel = new DoubleBoundedRangeModel(port.getName(), 100000, port.getMinimum(), port.getMaximum(), port.get());
        rangeModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DoubleBoundedRangeModel model = (DoubleBoundedRangeModel)e.getSource();
                double value = model.getDoubleValue();
                port.set(value);
            }
        });
        return new DoubleBoundedRangeSlider(rangeModel, 4);
    }

    public static DoubleBoundedRangeSlider createExponentialPortSlider(final UnitInputPort port) {
        ExponentialRangeModel rangeModel = new ExponentialRangeModel(port.getName(), 100000, port.getMinimum(), port.getMaximum(), port.get());
        rangeModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ExponentialRangeModel model = (ExponentialRangeModel)e.getSource();
                double value = model.getDoubleValue();
                port.set(value);
            }
        });
        return new DoubleBoundedRangeSlider(rangeModel, 4);
    }
}

